using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;

namespace Application_Monitor
{
    public partial class frmPulseOximteryOffline : Form
    {
        int intSamplingRate = 0;
        float intYConfigure = 0;
        Pen redPen = new Pen(Color.Red);
        int intSPo2Time = 0;
        string m_HR = "XXX";
        string m_Spo2 = "128";
        float m_PPIX = 0;
        float m_PPIY = 0;
        Graphics objSpo2Graphics;
        int intMaximum = 0;
        //create colored pens for drawing 
        Pen yelgpen = new Pen(Color.YellowGreen);
        string strFilePath = string.Empty;
        int intXScaling = 0;
        Bitmap bmpPulseOximetry = null;
        Bitmap bmpRed = null;
        short[] ushSpo2Data = null;       
        SpO2Data[] objSpO2Data = null;
        long lngLineCount = 0;
        Graphics objSpo2RedGraphics;
        string strHRValue = "XXX";
        string strSpO2Value = "128";
        float ftYScale = 1;
        Pen gridPen = new Pen(Color.DimGray);
        Pen objPenGraph1 = null;
        bool blnL1C1MouseDown = false;
        bool blnL1C2MouseDown = false;
        /// <summary>
        /// Used to set or get the browsed file path
        /// </summary>
        public string FilePath
        {
            get
            {
                return strFilePath;
            }
            set
            {
                strFilePath = value;
            }
        }

        public frmPulseOximteryOffline()
        {
            InitializeComponent();
           
            intSamplingRate = Convert.ToInt32(System.Configuration.ConfigurationSettings.AppSettings["Spo2SamplingRate"]);
            intYConfigure = (float)Convert.ToSingle(System.Configuration.ConfigurationSettings.AppSettings["Spo2YConfigure"]);
            intXScaling = (int)Constants.XScale.XSCale_25mm;
            intSPo2Time = (int)Constants.TimeForScaling.Time_25mmXScale;
            objSpO2Data = new SpO2Data[intSamplingRate * (int)Constants.TimeForScaling.Time_25mmXScale];
            for (int i = 0; i < intSamplingRate * (int)Constants.TimeForScaling.Time_25mmXScale; i++)
            {
                SpO2Data objSpO2 = new SpO2Data();
                objSpO2Data[i] = objSpO2;
            }            
            
        }

        private void frmPulseOximteryOffline_Load(object sender, EventArgs e)
        {
            this.CancelButton = btnCancel;

            string strFileName = string.Empty;
            if (strFilePath.LastIndexOf('\\') > -1)
            {
                strFileName = strFilePath.Substring(strFilePath.LastIndexOf('\\') + 1);
                if (strFileName.LastIndexOf('.') > -1)
                {
                    strFileName = strFileName.Substring(0, strFileName.LastIndexOf('.'));
                }
            }
           // MessageBox.Show(strFileName);
           // this.Text = strFileName + " - " + this.Text;
            lblFileNameValue.Text = strFileName;
            lngLineCount = GetSampleCount();
            SetControls();            
            GetSpO2Data();
            DrawSpo2Graph();
        }

       
        private void SetControls()
        {
            // Set the width and height of the picture boxes
            Graphics objGraphics = CreateGraphics();
            //Calculate the pixels per inch
            PixelsPerInch objPPI = new PixelsPerInch(objGraphics);
            m_PPIX = objPPI.PPIX;
            m_PPIY = objPPI.PPIY;
            int intWidth = (int)((intXScaling * intSPo2Time * m_PPIX) / 25.4);
            pbxPulseOximetry.Width = intWidth;
            bmpPulseOximetry = new Bitmap(pbxPulseOximetry.Width, pbxPulseOximetry.Height);
            pbxPulseOximetry.Image = bmpPulseOximetry;
            pbxRed.Width = intWidth;
            bmpRed = new Bitmap(pbxRed.Width, pbxRed.Height);
            pbxRed.Image = bmpRed;



            // Get the graphics handler reference
            objSpo2RedGraphics = Graphics.FromImage(bmpRed);
            SetHScrollBarSettings();
            lblScaleXtext.Text = intXScaling.ToString() + " " + Constants.XSCALE_MEASURE;
            // Get the graphics handler reference
            objSpo2Graphics = Graphics.FromImage(bmpPulseOximetry);
            lblScaleYText.Text = "100" + " %";
            this.Width = pbxPulseOximetry.Width + 200;
            gpScale.Left = pbxPulseOximetry.Right - gpScale.Width;
            //Set the left cursor
            pbxL1Cursor1.Height = pbxPulseOximetry.Height;
            pbxL1Cursor1.Top = pbxPulseOximetry.Top;
            pbxL1Cursor1.Left = pbxPulseOximetry.Left + (int)((intXScaling * m_PPIX) / 25.4);
            picRedArrow1.Top = pbxL1Cursor1.Bottom;
            picRedArrow1.Left = pbxL1Cursor1.Left - picRedArrow1.Width / 2;

            //Set the right cursor
            pbxL1Cursor2.Height = pbxPulseOximetry.Height;
            pbxL1Cursor2.Top = pbxPulseOximetry.Top;
            pbxL1Cursor2.Left = pbxPulseOximetry.Left + (int)((intXScaling * (intSPo2Time - 1) * m_PPIX) / 25.4);
            picPinkArrow1.Top = pbxL1Cursor2.Bottom;
            picPinkArrow1.Left = pbxL1Cursor2.Left - picPinkArrow1.Width / 2;

            lblLeadICursor.Top = pbxPulseOximetry.Top + pbxPulseOximetry.Height / 2;
            lblLead1Cursordata.Top = lblLeadICursor.Top;
            lblLeadICursor.Left = pbxPulseOximetry.Right + 10;
            lblLead1Cursordata.Left = lblLeadICursor.Right + 2;

            //Caluclate the time difference between the two cursors
            int intL1CursorDiff = pbxL1Cursor2.Left - pbxL1Cursor1.Left;
            float flt1CursorData = (float)(intL1CursorDiff * 25.4) / (m_PPIX * intXScaling);
            int intLen = flt1CursorData.ToString().Length;
            string strCursorData = string.Empty;
            if (intLen >= 4)
            {
                strCursorData = flt1CursorData.ToString().Substring(0, 4);
            }
            else
            {
                strCursorData = flt1CursorData.ToString().Substring(0, intLen);
            }
            lblLead1Cursordata.Text = strCursorData + " sec";

        }

        /// <summary>
        /// This is used to get the ECG from a selected file on load of the form
        /// </summary>
        private void GetSpO2Data()
        {
            StreamReader srECG = null;
            int intIndex = 0;
            try
            {
                string strData = null;
                //Create a new stream reader to read the file
                srECG = new StreamReader(strFilePath);
                strData = srECG.ReadLine();
                while (strData != null)
                {
                    if (intIndex <= objSpO2Data.Length)
                    {
                        if (!strData.Trim().ToLower().StartsWith("heart_rate")
                            && !strData.Trim().ToLower().StartsWith("spo2") && strData.Trim() != string.Empty)
                        {

                            if (strData.Length > 0)
                            {
                                string[] strSpo2Samples = strData.Split('\t');
                                //Infrared data
                                if (strSpo2Samples[0] != null)
                                    objSpO2Data[intIndex].SpO2Sample = Convert.ToInt16(strSpo2Samples[0]);
                                //Red data
                                if (strSpo2Samples[1] != null)
                                    objSpO2Data[intIndex].SpO2RedSample = Convert.ToInt16(strSpo2Samples[1]);

                                objSpO2Data[intIndex].IsDraw = true;
                                objSpO2Data[intIndex].HeartRate = strHRValue;
                                objSpO2Data[intIndex].SpO2 = strSpO2Value;
                                intIndex++;

                            }

                        }
                    //Get the heart rate information from ECG file
                        else if (strData.Trim().ToLower().StartsWith("heart_rate")
                             && strData.Trim() != string.Empty)
                        {
                            string[] strSamples = strData.Split('\t');

                            if (strSamples.Length > 0)
                            {
                                if (strSamples[1] != null)
                                {
                                    strHRValue = strSamples[1];
                                }
                            }
                        }
                        //Get the Lead OFF Status information from ECG file
                        else if (strData.Trim().ToLower().StartsWith("spo2")
                        && strData.Trim() != string.Empty)
                        {
                            string[] strSamples = strData.Split('\t');

                            if (strSamples.Length > 0)
                            {
                                if (strSamples[1] != null)
                                {
                                    strSpO2Value = strSamples[1];
                                }
                            }


                        }
                    }
                    strData = srECG.ReadLine();
                }
            }
            catch (Exception objEcxeption)
            {
                string str = objEcxeption.Message;


            }
            finally
            {
                if (srECG != null)
                {
                    srECG.Close();
                    srECG.Dispose();
                }
                srECG = null;
            }
        }

        /// <summary>
        /// This function is used to get the ECG data from specified position.
        /// </summary>
        /// <param name="intStart">Start Position</param>
        /// <param name="intEnd">End Position</param>
        private void GetSpO2Data(int intStart, int intEnd)
        {
            //MessageBox.Show("Start-"+ intStart.ToString() + " " + "End-" + intEnd.ToString());
            StreamReader srECG = null;
            int intSample = 0;
            int intIndex = 0;

            try
            {
                string strData = null;
                srECG = new StreamReader(strFilePath);
                strData = srECG.ReadLine();
                objSpO2Data = null;
                objSpO2Data = new SpO2Data[intSamplingRate * (int)Constants.TimeForScaling.Time_25mmXScale];
                for (int i = 0; i < intSamplingRate * (int)Constants.TimeForScaling.Time_25mmXScale; i++)
                {
                    SpO2Data objspo2 = new SpO2Data();
                    objSpO2Data[i] = objspo2;
                    strSpO2Value = "128";
                }

                while (strData != null)
                {
                    //Read 8 leads sample data from an ECG file and save it in a buffer 
                    if (!strData.Trim().ToLower().StartsWith("heart_rate")
                        && !strData.Trim().ToLower().StartsWith("spo2") && strData.Trim() != string.Empty)
                    {

                        if (intSample >= intStart && intSample < intEnd)
                        {

                            if (intIndex <= objSpO2Data.Length)
                            {
                                if (strData.Length > 0)
                                {
                                    string[] strSpo2Samples = strData.Split('\t');
                                    //Infrared data
                                    if (strSpo2Samples[0] != null)
                                        objSpO2Data[intIndex].SpO2Sample = Convert.ToInt16(strSpo2Samples[0]);
                                    //Red data
                                    if (strSpo2Samples[1] != null)
                                        objSpO2Data[intIndex].SpO2RedSample = Convert.ToInt16(strSpo2Samples[1]);

                                    objSpO2Data[intIndex].IsDraw = true;
                                    objSpO2Data[intIndex].HeartRate = strHRValue;
                                    objSpO2Data[intIndex].SpO2 = strSpO2Value;
                                    intIndex++;

                                }
                            }
                        }
                        intSample++;
                    }
                    //Get the heart rate information from ECG file
                    else if (strData.Trim().ToLower().StartsWith("heart_rate")
                         && strData.Trim() != string.Empty)
                    {
                        string[] strSamples = strData.Split('\t');

                        if (strSamples.Length > 0)
                        {
                            if (strSamples[1] != null)
                            {
                                 strHRValue = strSamples[1];
                                
                            }
                        }
                    }
                    //Get the Lead OFF Status information from ECG file
                    else if (strData.Trim().ToLower().StartsWith("spo2")
                    && strData.Trim() != string.Empty)
                    {
                        string[] strSamples = strData.Split('\t');

                        if (strSamples.Length > 0)
                        {
                            if (strSamples[1] != null)
                            {
                                strSpO2Value = strSamples[1];                                
                            }
                        }


                    }
                    strData = srECG.ReadLine();
                }
            }
            catch (Exception objEcxeption)
            {
                string str = objEcxeption.Message;
            }
            finally
            {
                if (srECG != null)
                {
                    srECG.Close();
                    srECG.Dispose();
                }
                srECG = null;
            }
        }
      

        /// <summary>
        /// This function counts the total number of samples from the saved SPO2 file
        /// </summary>
        /// <returns></returns>
        private long GetSampleCount()
        {
            StreamReader srECG = null;
            try
            {
                string strData = null;
                //Opens a stream reader to read the file
                srECG = new StreamReader(strFilePath);
                strData = srECG.ReadLine();
                while (strData != null)
                {
                    if (!strData.Trim().ToLower().StartsWith("heart_rate")
                        && !strData.Trim().ToLower().StartsWith("spo2") && strData.Trim() != string.Empty)
                    {

                        lngLineCount++;
                    }
                    strData = srECG.ReadLine();
                }
            }
            catch (Exception objEcxeption)
            {
                string str = objEcxeption.Message;
            }
            finally
            {
                if (srECG != null)
                {
                    srECG.Close();
                    srECG.Dispose();
                }
                srECG = null;
            }
            return lngLineCount;
        }

        private void DrawSpo2Graph()
        {
            objSpo2Graphics.Clear(Color.Black);
           // objSpo2RedGraphics.Clear(Color.Black);

            int intDisplayStaticBuffer = 0;
            float pxStatic = 0, x2Static = 0;
            float pyStatic = 0, y2Graph1Static = 0;
            float pyRedStatic = 0, y2RedGraph1Static = 0;
            SpO2Data[] objSpO2 = null;
            if (intSPo2Time == (int)Constants.TimeForScaling.Time_25mmXScale)
            {
                objSpO2 = objSpO2Data;
            }
            else
            {
                objSpO2 = new SpO2Data[intSamplingRate * (int)Constants.TimeForScaling.Time_50mmXScale];
                for (int i = 0; i < intSamplingRate * (int)Constants.TimeForScaling.Time_50mmXScale; i++)
                {
                    SpO2Data obj = new SpO2Data();
                    objSpO2[i] = obj;
                }
                int i50 = 0;
                for (int intCount = 0; intCount < objSpO2.Length; intCount++)
                {
                    if (objSpO2Data[intCount].IsDraw)
                    {
                        objSpO2[i50].IsDraw = objSpO2Data[intCount].IsDraw;
                        objSpO2[i50].HeartRate = objSpO2Data[intCount].HeartRate;
                        objSpO2[i50].SpO2Sample = objSpO2Data[intCount].SpO2Sample;
                        objSpO2[i50].SpO2RedSample = objSpO2Data[intCount].SpO2RedSample;
                        objSpO2[i50].SpO2 = objSpO2Data[intCount].SpO2;
                        if (i50 == intSamplingRate * (int)Constants.TimeForScaling.Time_50mmXScale - 1)
                        {
                            i50 = 0;
                        }
                        else
                        {
                            i50++;
                        }
                    }

                }
                //for (int intCount = 0; intCount < objSpO2Data.Length; intCount++)
                //{
                //    if (objSpO2Data[intCount].IsDraw)
                //    {
                //        objSpO2[i50].IsDraw = objSpO2Data[intCount].IsDraw;
                //        objSpO2[i50].HeartRate = objSpO2Data[intCount].HeartRate;
                //        objSpO2[i50].SpO2Sample = objSpO2Data[intCount].SpO2Sample;
                //        objSpO2[i50].SpO2RedSample = objSpO2Data[intCount].SpO2RedSample;
                //        objSpO2[i50].SpO2 = objSpO2Data[intCount].SpO2;
                //        if (i50 == intSamplingRate * (int)Constants.TimeForScaling.Time_50mmXScale - 1)
                //        {
                //            i50 = 0;
                //        }
                //        else
                //        {
                //            i50++;
                //        }
                //    }

                //}
            }
            DrawGrid();
            //Traverse through the points one by one to draw the ECG graphs
            for (int intCount = 0; intCount < objSpO2.Length; intCount = intCount + 1)
            {
                if (objSpO2[intCount].IsDraw)
                {  
                    lblHRText.Text = objSpO2[intCount].HeartRate;
                    byte[] bytSpo2 = new byte[1];
                    bytSpo2[0] = Convert.ToByte(objSpO2[intCount].SpO2);
                    BitArray bitarr = new BitArray(bytSpo2);
                    objPenGraph1 = yelgpen;
                    if (bitarr != null && bitarr.Length == 8 && bitarr[7])
                    {
                        objPenGraph1 = redPen;
                    }
                    bitarr.Set(7, false);
                    byte[] byt = new byte[1];
                    bitarr.CopyTo(byt, 0);
                    lblSpO2Text.Text = byt[0].ToString() + "%";
                    //lblSpO2Text.Text = objSpO2[intCount].SpO2 + " %";
                    x2Static = (intDisplayStaticBuffer + 1) * (float)(((intXScaling * m_PPIX) / 25.4) / intSamplingRate);
                    //Draw Red graph
                    //y2RedGraph1Static = (pbxPulseOximetry.Height/2) - (objSpO2[intCount].SpO2RedSample * ftYScale / intYConfigure);
                    //objSpo2RedGraphics.DrawLine(objPenGraph1, pxStatic, pyRedStatic, x2Static, y2RedGraph1Static);
                    //pbxRed.Image = bmpRed;
                    //pyRedStatic = y2RedGraph1Static;

                    //Draw Infra Red graph
                    y2Graph1Static = (pbxPulseOximetry.Height /2) - (objSpO2[intCount].SpO2Sample * ftYScale / intYConfigure);
                    if (intDisplayStaticBuffer == 0)
                    {
                        pyStatic = y2Graph1Static;
                    }
                    objSpo2Graphics.DrawLine(objPenGraph1, pxStatic, pyStatic, x2Static, y2Graph1Static);
                    pbxPulseOximetry.Image = bmpPulseOximetry;
                    pxStatic = x2Static;
                    pyStatic = y2Graph1Static;
                    intDisplayStaticBuffer++;

                }
            }
            pbxPulseOximetry.Image = bmpPulseOximetry;
            pbxRed.Image = bmpRed;

        }
        /// <summary>
        /// This is used to set the HScroll bar settings
        /// </summary>
        private void SetHScrollBarSettings()
        {
            hScrollBar.Top = pbxPulseOximetry.Top + pbxPulseOximetry.Height + 10;
            hScrollBar.Width = pbxPulseOximetry.Width;
            intMaximum = (int)lngLineCount / intSamplingRate;

            hScrollBar.SmallChange = 1;
            hScrollBar.LargeChange = 1;
            hScrollBar.Value = 0;
            if (intMaximum - intSPo2Time >= 1)
            {
                hScrollBar.Maximum = ((intMaximum - intSPo2Time));//30;
            }
            else
            {
                hScrollBar.Maximum = 0;
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnXScaling_Click(object sender, EventArgs e)
        {
            ScalingOnTime();
        }
        /// <summary>
        /// This method is used to display the selected Y - Scale 5, 10 0r 20 mm/mV
        /// </summary>
        private void ScalingOnTime()
        {
          

            switch (intXScaling)
            {
                case (int)Constants.XScale.XSCale_25mm:
                    {
                        intXScaling = (int)Constants.XScale.XSCale_50mm;
                        intSPo2Time = (int)Constants.TimeForScaling.Time_50mmXScale;
                        lblScaleXtext.Text = intXScaling.ToString() + " " + Constants.XSCALE_MEASURE;
                        break;


                    }
                case (int)Constants.XScale.XSCale_50mm:
                    {

                        intXScaling = (int)Constants.XScale.XSCale_25mm;
                        intSPo2Time = (int)Constants.TimeForScaling.Time_25mmXScale;
                        lblScaleXtext.Text = intXScaling.ToString() + " " + Constants.XSCALE_MEASURE;
                        break;
                    }

                default:
                    break;
            }
            SetControlsOnTiming();
            DrawSpo2Graph();
            SetHScrollBarSettings();
            lblScaleXtext.Text = intXScaling.ToString() + " " + Constants.XSCALE_MEASURE;
            
            

        }

        /// <summary>
        /// This function is used to draw the grid lines on the graphs
        /// </summary>
        private void DrawGrid()
        {
           // float flt5mmYAxis = (10 * m_PPIY) / 25.4F;
            int intHorLines = pbxPulseOximetry.Height / 25;
            //Draw horizontal lines  
            for (int i = 0; i < intHorLines; i++)
            {
                objSpo2Graphics.DrawLine(gridPen, 0, i * 25, pbxPulseOximetry.Width, i * 25);
                //objSpo2RedGraphics.DrawLine(gridPen, 0, i * flt5mmYAxis, pbxRed.Width, i * flt5mmYAxis);

            }

            //Draw Vertical lines
            float flt5mmXAxis = (10 * m_PPIX) / 25.4F;
            int intVertLines = (intSPo2Time * intXScaling) / 10;
            for (int i = 0; i < intVertLines; i++)
            {
                objSpo2Graphics.DrawLine(gridPen, i * flt5mmXAxis, 0, i * flt5mmXAxis, pbxPulseOximetry.Height);
               // objSpo2RedGraphics.DrawLine(gridPen, i * flt5mmXAxis, 0, i * flt5mmXAxis, pbxRed.Height);

            }
            pbxPulseOximetry.Image = bmpPulseOximetry;
           // pbxRed.Image = bmpRed;

        }

        /// <summary>
        /// This method is used to display the selected Y - Scale 5, 10 0r 20 mm/mV
        /// </summary>
        private void ScalingOnYAxis()
        {


            if (ftYScale == 1)
            {
                ftYScale = 2;
                lblScaleYText.Text = "200" + " %";
            }
            else if (ftYScale == 2)
            {
                ftYScale = 3f;
                lblScaleYText.Text = "300" + " %";
            }
            else if (ftYScale == 3)
            {
                ftYScale = 0.5f;
                lblScaleYText.Text = "50" + " %";
            }
            else if (ftYScale == 0.5F)
            {
                ftYScale = 0.75f;
                lblScaleYText.Text = "75" + " %";
            }
            else if (ftYScale == 0.75F)
            {
                ftYScale = 1;
                lblScaleYText.Text = "100" + " %";
            }

            DrawSpo2Graph();
        }

        private void hScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            int intNewValue = e.NewValue;
            //Retrieve and draw the samples data from the ECG file depending on the Scroll bar postion
            //and Scroll bar event type
            switch (e.Type)
            {
                case ScrollEventType.SmallIncrement:
                    {
                        //intCount++;
                        if (e.NewValue == (hScrollBar.Maximum - hScrollBar.LargeChange) + 1)
                        {
                            
                            GetSpO2Data(Convert.ToInt32(lngLineCount) - (intSamplingRate * (int)Constants.TimeForScaling.Time_25mmXScale), Convert.ToInt32(lngLineCount));
                        }
                        else
                        {
                            GetSpO2Data(e.NewValue * intSamplingRate, (e.NewValue + (int)Constants.TimeForScaling.Time_25mmXScale) * intSamplingRate);
                        }
                        break;
                    }
                case ScrollEventType.LargeIncrement:
                    {

                      //  intCount = intCount + 1;
                        if (e.NewValue == (hScrollBar.Maximum - hScrollBar.LargeChange) + 1)
                        {
                            GetSpO2Data(Convert.ToInt32(lngLineCount) - (intSamplingRate * (int)Constants.TimeForScaling.Time_25mmXScale), Convert.ToInt32(lngLineCount));

                        }
                        else
                        {
                            GetSpO2Data(e.NewValue * intSamplingRate, (e.NewValue + (int)Constants.TimeForScaling.Time_25mmXScale) * intSamplingRate);
                        }

                        break;
                    }
                case ScrollEventType.SmallDecrement:
                    {
                        GetSpO2Data(e.NewValue * intSamplingRate, (e.NewValue + (int)Constants.TimeForScaling.Time_25mmXScale) * intSamplingRate);
                        break;
                    }
                case ScrollEventType.LargeDecrement:
                    {
                        GetSpO2Data(e.NewValue * intSamplingRate, (e.NewValue + (int)Constants.TimeForScaling.Time_25mmXScale) * intSamplingRate);
                        break;
                    }
                case ScrollEventType.ThumbTrack:
                    {
                        GetSpO2Data(e.NewValue * intSamplingRate, (e.NewValue + (int)Constants.TimeForScaling.Time_25mmXScale) * intSamplingRate);
                        break;
                    }
                case ScrollEventType.ThumbPosition:
                    {
                        break;
                    }
                default:
                    break;
            }
            DrawSpo2Graph();  
        }

     
        private void btnScale_Click(object sender, EventArgs e)
        {
            ScalingOnYAxis();
        }

        private void picRedArrow1_MouseDown(object sender, MouseEventArgs e)
        {
            blnL1C1MouseDown = true;
        }

        private void picRedArrow1_MouseHover(object sender, EventArgs e)
        {
            Cursor = Cursors.SizeAll;
        }

        private void picRedArrow1_MouseLeave(object sender, EventArgs e)
        {
            Cursor = Cursors.Default;
        }

        private void picRedArrow1_MouseMove(object sender, MouseEventArgs e)
        {
            if (blnL1C1MouseDown)
            {
                int newPosition = picRedArrow1.Left + e.X;

                // Checks whether the Left Cursor position falls with in the picture box 
                //and does not exceeds the Right cursor
                if (newPosition > pbxPulseOximetry.Left && newPosition < pbxPulseOximetry.Right && newPosition < pbxL1Cursor2.Left)
                {
                    picRedArrow1.Location = new Point(newPosition - 7, picRedArrow1.Location.Y);
                    pbxL1Cursor1.Location = new Point(newPosition, pbxL1Cursor1.Location.Y);
                    //Calculate the time difference between the cursors
                    int intL1CursorDiff = pbxL1Cursor2.Left - pbxL1Cursor1.Left;
                    //SetLead1Cursors(pbxL1Cursor1, pbxL1Cursor2);
                    float flt1CursorData = (float)(intL1CursorDiff * 25.4) / (m_PPIX * intXScaling);
                    int intLen1 = flt1CursorData.ToString().Length;
                    string strCursor1Data = string.Empty;
                    if (intLen1 >= 4)
                    {
                        strCursor1Data = flt1CursorData.ToString().Substring(0, 4);
                    }
                    else
                    {
                        strCursor1Data = flt1CursorData.ToString().Substring(0, intLen1);
                    }
                    //Display the time difference between the cursors
                    lblLead1Cursordata.Text = strCursor1Data + " sec";

                }

            }
        }

        private void picRedArrow1_MouseUp(object sender, MouseEventArgs e)
        {
            if (blnL1C1MouseDown)
            {
                blnL1C1MouseDown = false;
            }
        }

        private void picPinkArrow1_MouseDown(object sender, MouseEventArgs e)
        {
            blnL1C2MouseDown = true;
        }

        private void picPinkArrow1_MouseHover(object sender, EventArgs e)
        {
            Cursor = Cursors.SizeAll;
        }

        private void picPinkArrow1_MouseLeave(object sender, EventArgs e)
        {
            Cursor = Cursors.Default;
        }

        private void picPinkArrow1_MouseMove(object sender, MouseEventArgs e)
        {
            if (blnL1C2MouseDown)
            {
                int newPosition = picPinkArrow1.Left + e.X;
                // Checks whether the Right Cursor position falls with in the picture box 
                //and does not exceeds the Left cursor
                if (newPosition > pbxPulseOximetry.Left && newPosition < pbxPulseOximetry.Right && newPosition > pbxL1Cursor1.Left)
                {
                    picPinkArrow1.Location = new Point(newPosition - 7, picPinkArrow1.Location.Y);
                    pbxL1Cursor2.Location = new Point(newPosition, pbxL1Cursor2.Location.Y);
                    //Calculate the time difference between the cursors
                    int intL1CursorDiff = pbxL1Cursor2.Left - pbxL1Cursor1.Left;
                  //  SetLead1Cursors(pbxL1Cursor1, pbxL1Cursor2);
                    float flt1CursorData = (float)(intL1CursorDiff * 25.4) / (m_PPIX * intXScaling);
                    int intLen1 = flt1CursorData.ToString().Length;
                    string strCursor1Data = string.Empty;
                    if (intLen1 >= 4)
                    {
                        strCursor1Data = flt1CursorData.ToString().Substring(0, 4);
                    }
                    else
                    {
                        strCursor1Data = flt1CursorData.ToString().Substring(0, intLen1);
                    }
                    //Displays the time difference between the cursors
                    lblLead1Cursordata.Text = strCursor1Data + " sec";

                }
            }
        }

        private void picPinkArrow1_MouseUp(object sender, MouseEventArgs e)
        {
            if (blnL1C2MouseDown)
            {
                blnL1C2MouseDown = false;
            }
        }

        /// <summary>
        /// This is used to set the properties of froms controls
        /// All the controls will be aligned properly depending on the Pixels per inch
        /// of a system, XScaling(measurement in mm per sec) and total time to be displayed.
        /// </summary>
        private void SetControlsOnTiming()
        {
            int intWidth = (int)((intXScaling * intSPo2Time * m_PPIX) / 25.4);
          //  int intHeight = (int)((intYHeight * m_PPIY) / 25.4);
            //Set the left cursor
            pbxL1Cursor1.Height = pbxPulseOximetry.Height;
            pbxL1Cursor1.Top = pbxPulseOximetry.Top;
            pbxL1Cursor1.Left = pbxPulseOximetry.Left + (int)((intXScaling * m_PPIX) / 25.4);
            picRedArrow1.Top = pbxL1Cursor1.Bottom;
            picRedArrow1.Left = pbxL1Cursor1.Left - picRedArrow1.Width / 2;

            //Set the right cursor
            pbxL1Cursor2.Height = pbxPulseOximetry.Height;
            pbxL1Cursor2.Top = pbxPulseOximetry.Top;
            pbxL1Cursor2.Left = pbxPulseOximetry.Left + (int)((intXScaling * (intSPo2Time - 1) * m_PPIX) / 25.4);
            picPinkArrow1.Top = pbxL1Cursor2.Bottom;
            picPinkArrow1.Left = pbxL1Cursor2.Left - picPinkArrow1.Width / 2;

            lblLeadICursor.Top = pbxPulseOximetry.Top + pbxPulseOximetry.Height / 2;
            lblLead1Cursordata.Top = lblLeadICursor.Top;
            lblLeadICursor.Left = pbxPulseOximetry.Right + 10;
            lblLead1Cursordata.Left = lblLeadICursor.Right + 2;

            //Caluclate the time difference between the two cursors
            int intL1CursorDiff = pbxL1Cursor2.Left - pbxL1Cursor1.Left;
            float flt1CursorData = (float)(intL1CursorDiff * 25.4) / (m_PPIX * intXScaling);
            int intLen = flt1CursorData.ToString().Length;
            string strCursorData = string.Empty;
            if (intLen >= 4)
            {
                strCursorData = flt1CursorData.ToString().Substring(0, 4);
            }
            else
            {
                strCursorData = flt1CursorData.ToString().Substring(0, intLen);
            }
            lblLead1Cursordata.Text = strCursorData + " sec";
           
           
           
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
          //  DisposeGraphicObjects();
            this.Close();
        }

        private void mnuOpen_Click(object sender, EventArgs e)
        {
            OpenFileDialogBox();
        }

        /// <summary>
        /// This functio opens the OpenFileDialog
        /// </summary>
        private void OpenFileDialogBox()
        {
            openFileDialog.DefaultExt = Constants.SPO2_FILE_EXTENSION;
            openFileDialog.AddExtension = true;

            openFileDialog.Filter = "spo2 Files (*.spo2)|*.spo2|All files (*.*)|*.*";
            openFileDialog.Multiselect = false;
            string strPath = Application.StartupPath + "\\SpO2\\";
            try
            {
                if (!Directory.Exists(strPath))
                {
                    Directory.CreateDirectory(strPath);
                }
            }
            catch (Exception objException)
            {
                string str = objException.Message;
            }
            openFileDialog.InitialDirectory = strPath;
            openFileDialog.FileName = string.Empty;
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                string strFileName = string.Empty;
                strFileName = openFileDialog.FileName;
                if (strFileName != string.Empty)
                {
                    if (!File.Exists(strFileName))
                    {
                        MessageBox.Show("File does not exsits", "", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                    else
                    {
                        string strExtension = strFileName.Substring(strFileName.LastIndexOf('.'));
                        if (strExtension.Trim().ToLower() == Constants.SPO2_FILE_EXTENSION.Trim().ToLower())
                        {
                            frmPulseOximteryOffline objfrmOfflineMonitor = new frmPulseOximteryOffline();
                            objfrmOfflineMonitor.FilePath = strFileName.Trim();
                            objfrmOfflineMonitor.Show();
                        }
                        else
                        {
                            MessageBox.Show("Please select or enter an SpO2 file.", "", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        }
                    }
                }
                else
                {
                    MessageBox.Show("Please select or enter an SpO2 file.", "", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
            }
        }
    }
}